/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于反馈界面
 *
 * 修改:
 *      类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.12.14
 *      内容 : 所有代码
 *************************************************************************************************/

/* export mc_get_list_cnt; */
/* export mc_get_list; */
/* export mc_set_solved_issue; */

/* global $ */
/* global mc_sdk_param */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取close列表
 * 参数:
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.12.14
 *      内容 : 所有代码
 ************************************************************************************************/
// function mc_page_number(ui_page_idx) {
//     var ui_vers_cnt = g_obj_page_ination;
//     var ui_vers_start = (ui_page_idx - 1) * 5;
//     var ui_vers_end = ui_page_idx * 5;

//     if (ui_vers_end > ui_vers_cnt) {
//         ui_vers_end = ui_vers_cnt;
//     }
// }


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取close列表
 * 参数:
 *    @param {Promise<string>} str_tpye     问题;列表/已解决列表 OPEN/CLOSED
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.12.15
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_get_list_cnt(str_tpye, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var obj_get_open_list = new mc_sdk_param();

    obj_get_open_list.set_param_clear();
    obj_get_open_list.set_cmd("GET_PARAM");
    obj_get_open_list.set_func("ISSUES_LIST_CNT");
    obj_get_open_list.set_param_value("TYPE", str_tpye);

    $.post("http://localhost:8001/api/issues", obj_get_open_list.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_req = new mc_sdk_param();

        obj_req.set_json(result);
        var error = obj_req.get_param_value("ERROR_CODE");
        var str_cnt = obj_req.get_param_value("COUNT");

        fun_callback(str_cnt, error);

        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取close列表
 * 参数:
 *    @param {Promise<string>} str_tpye     问题;列表/已解决列表 OPEN/CLOSED
 *    @param {Promise<string>} list_idx     列表索引
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.12.15
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_get_list(str_tpye, list_idx, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var obj_get_open_list = new mc_sdk_param();

    obj_get_open_list.set_param_clear();
    obj_get_open_list.set_cmd("GET_PARAM");
    obj_get_open_list.set_func("ISSUES_LIST");
    obj_get_open_list.set_param_value("SECTION", list_idx);
    obj_get_open_list.set_param_value("TYPE", str_tpye);
    // var obj_req_content={
    //     url:''
    // }

    $.post("http://localhost:8001/api/issues", obj_get_open_list.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var arr_return = [];
        var obj_req = new mc_sdk_param();

        var obj_each = {
            "issue_id": "",
            "user_id": "",
            "user_name": "",
            "time": "",
            "title": "",
            "issue_data": "",
            "issue_level": "",
            "comment_list": ""
        };

        obj_req.set_json(result);
        var error = obj_req.get_param_value("ERROR_CODE");
        var ui_param_cnt = obj_req.get_param_cnt();

        for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
            var str_param_name = obj_req.get_param_name(idx_param);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            }
            obj_each.issue_id = str_param_name;
            console.log(str_param_name);

            var ui_attr_cnt = obj_req.get_attr_cnt(str_param_name);

            for (var idx_attr = 0; idx_attr < ui_attr_cnt; idx_attr++) {
                var str_attr_name = obj_req.get_attr_name(str_param_name, idx_attr);

                switch (str_attr_name) {
                case "USER_ID":
                    obj_each.user_id = obj_req.get_attr_val(str_param_name, str_attr_name);
                    break;
                case "USER_NAME":
                    obj_each.user_name = obj_req.get_attr_val(str_param_name, str_attr_name);
                    break;
                case "TIME":
                    obj_each.time = obj_req.get_attr_val(str_param_name, str_attr_name);
                    break;
                case "TITLE":
                    obj_each.title = obj_req.get_attr_val(str_param_name, str_attr_name);
                    break;
                case "VALUE":
                    obj_each.issue_data = obj_req.get_attr_val(str_param_name, str_attr_name);
                    break;
                case "LEVEL":
                    obj_each.issue_level = obj_req.get_attr_val(str_param_name, str_attr_name);
                    break;
                case "COMMENT":
                    obj_each.comment_list = obj_req.get_attr_val(str_param_name, str_attr_name);
                    break;

                default:
                    break;
                }
            }
            arr_return.push(JSON.parse(JSON.stringify(obj_each)));
        }


        fun_callback(arr_return, error);

        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置未解决问题为已解决
 * 参数:
 *    @param {Promise<string>} str_user_id     作者id
 *    @param {Promise<function>} str_title     标题
 *    @param {Promise<function>} str_issue_id     问题id
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.12.15
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_set_solved_issue(str_user_id, str_title, str_issue_id, fun_callback) {
    var obj_get_open_list = new mc_sdk_param();

    obj_get_open_list.set_param_clear();
    obj_get_open_list.set_cmd("SET_PARAM");
    obj_get_open_list.set_func("ISSUES");
    obj_get_open_list.set_param_value("USER_ID", str_user_id);
    obj_get_open_list.set_param_value("TYPE", "CLOSED");
    obj_get_open_list.set_param_value("TITLE", str_title);
    obj_get_open_list.set_param_value("VALUE", str_issue_id);

    $.post("http://localhost:8001/api/issues", obj_get_open_list.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_req = new mc_sdk_param();

        obj_req.set_json(result);
        var error = obj_req.get_param_value("ERROR_CODE");

        fun_callback(error);
        return;
    });
}
